if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface Index_Params {
    globalDarkMode?: boolean;
    listenerId?: string;
}
import router from "@ohos:router";
import type { BusinessError } from "@ohos:base";
import ThemeManager from "@bundle:com.example.myapplication/entry/ets/common/ThemeManager";
class Index extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.__globalDarkMode = new ObservedPropertySimplePU(false, this, "globalDarkMode");
        this.listenerId = '';
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: Index_Params) {
        if (params.globalDarkMode !== undefined) {
            this.globalDarkMode = params.globalDarkMode;
        }
        if (params.listenerId !== undefined) {
            this.listenerId = params.listenerId;
        }
    }
    updateStateVars(params: Index_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__globalDarkMode.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__globalDarkMode.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    private __globalDarkMode: ObservedPropertySimplePU<boolean>;
    get globalDarkMode() {
        return this.__globalDarkMode.get();
    }
    set globalDarkMode(newValue: boolean) {
        this.__globalDarkMode.set(newValue);
    }
    private listenerId: string;
    async aboutToAppear(): Promise<void> {
        this.globalDarkMode = await ThemeManager.getIsDarkMode();
        this.listenerId = ThemeManager.addListener((isDark: boolean) => {
            this.globalDarkMode = isDark;
        });
    }
    aboutToDisappear(): void {
        ThemeManager.removeListener(this.listenerId);
    }
    getBackgroundColor(): string {
        return this.globalDarkMode ? '#000000' : '#F1F3F5';
    }
    getTextColor(): string {
        return this.globalDarkMode ? '#FFFFFF' : '#000000';
    }
    getButtonColor(buttonType: string): string {
        switch (buttonType) {
            case 'primary':
                return this.globalDarkMode ? '#007AFF' : '#007DFF';
            case 'secondary':
                return this.globalDarkMode ? '#34C759' : '#34C759';
            case 'tertiary':
                return this.globalDarkMode ? '#5856D6' : '#007AFF';
            default:
                return this.globalDarkMode ? '#007AFF' : '#007DFF';
        }
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create({ space: 20 });
            Column.width('100%');
            Column.height('100%');
            Column.padding(20);
            Column.justifyContent(FlexAlign.Center);
            Column.backgroundColor(this.getBackgroundColor());
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('应用主页');
            Text.fontSize(30);
            Text.fontWeight(FontWeight.Bold);
            Text.margin({ bottom: 40 });
            Text.fontColor(this.getTextColor());
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel('自律模式');
            Button.type(ButtonType.Capsule);
            Button.width('80%');
            Button.height(50);
            Button.backgroundColor(this.getButtonColor('primary'));
            Button.fontColor('#FFFFFF');
            Button.onClick(() => {
                router.pushUrl({
                    url: 'pages/SelfDiscipline'
                });
            });
        }, Button);
        Button.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel('音乐放松');
            Button.type(ButtonType.Capsule);
            Button.width('80%');
            Button.height(50);
            Button.backgroundColor(this.getButtonColor('secondary'));
            Button.fontColor('#FFFFFF');
            Button.onClick(() => {
                router.pushUrl({
                    url: 'pages/MusicRelax'
                });
            });
        }, Button);
        Button.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel('AI问答');
            Button.type(ButtonType.Capsule);
            Button.width('80%');
            Button.height(50);
            Button.backgroundColor(this.getButtonColor('tertiary'));
            Button.fontColor('#FFFFFF');
            Button.onClick(() => {
                router.pushUrl({
                    url: 'pages/AIQna'
                }).then(() => {
                    console.info('页面跳转成功');
                }).catch((err: BusinessError) => {
                    console.error(`跳转失败: ${JSON.stringify(err)}`);
                });
            });
        }, Button);
        Button.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel('我的页面');
            Button.type(ButtonType.Capsule);
            Button.width('80%');
            Button.height(50);
            Button.backgroundColor(this.globalDarkMode ? '#8E8E93' : '#8E8E93');
            Button.fontColor('#FFFFFF');
            Button.onClick(() => {
                router.pushUrl({
                    url: 'pages/Mypage'
                });
            });
        }, Button);
        Button.pop();
        Column.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName(): string {
        return "Index";
    }
}
registerNamedRoute(() => new Index(undefined, {}), "", { bundleName: "com.example.myapplication", moduleName: "entry", pagePath: "pages/Index", pageFullPath: "entry/src/main/ets/pages/Index", integratedHsp: "false" });
